﻿using System;
using System.Collections;
using System.Windows;
using System.Windows.Data;

namespace WPF.PresentationLayer.Converters
{
    public class ContainsTextBoolConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null || parameter == null) return false;

            return value.ToString().IndexOf(parameter.ToString(), StringComparison.OrdinalIgnoreCase) >= 0;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
